#include "stdlogger.h"

stdLogger::stdLogger(QObject *parent): QObject(parent)
{
  memset(errorBuffer, 0, sizeof(errorBuffer));
  setvbuf(stderr, errorBuffer, _IOFBF, sizeof(errorBuffer));

  // set up QTimer to call logErrors periodically
  timer = new QTimer(this);
  timer->start(10);
  connect(timer, SIGNAL(timeout()), this, SLOT(logErrors()));
}


void stdLogger::logErrors()
{
  fflush(stderr);
  QString t;
  // if there is stuff in the buffer, send it as errorMessage signal and clear the buffer
  if(strlen(errorBuffer) > 0)
    {
      emit errorMessage(errorBuffer);        // send buffer content to gui
      t=errorBuffer;
      qDebug() << "mine" << t;
      memset(errorBuffer, 0, sizeof(errorBuffer));
    }
}
