#ifndef STDLOGGER_H
#define STDLOGGER_H

#include <QObject>
#include <QTimer>
#include <QDebug>

#include <iostream>
#include <stdio.h>

#define BUFFERSIZE 655360

// This class catches the stderr console output from all called libaries and emits it as signal.
// The stderr stream is buffered in errorBuffer. logErrors() checks the buffer periodically, invoked by a QTimer (every 500ms). If there is content available it is sent via the errorMessage signal to the gui.

class stdLogger: public QObject
{
    Q_OBJECT
public:
  explicit stdLogger(QObject *parent = 0);

signals:
  void errorMessage(QString message);

public slots:
 void logErrors();

private:
 char errorBuffer[BUFFERSIZE];
 QTimer *timer;
};

#endif // STDLOGGER_H

