#include "extviewer.h"
#include "ui_extviewer.h"
#include <QFileInfo>
#include <QDebug>

extViewer::extViewer(QWidget *parent) :   QDialog(parent),   ui(new Ui::extViewer)
{
  ui->setupUi(this);
  activeMovie=false;
  setModal(false);
}

extViewer::~extViewer()
{
  delete ui;
}


void extViewer::setup(QImage image,QString fn)
{
//  QRect rct;
//  int dw,dh;
  im=image;
  fileName=fn;
  QFileInfo fi(fn);
  resize(im.width()+4,im.height()+30);
  ui->imageLabel->setSizePolicy(QSizePolicy::Ignored, QSizePolicy::Ignored);
  ui->imageLabel->setScaledContents(false);
  ui->lineEdit->setText(QString("%1 %2x%3").arg(fi.fileName()).arg(im.width()).arg(im.height()));
}

void extViewer::paintEvent ( QPaintEvent * )
{
  QFileInfo fi(fileName);
  if(labelWidth==ui->imageLabel->width() && labelHeight==ui->imageLabel->height())
    {
      return;
    }
  labelWidth=ui->imageLabel->width();
  labelHeight=ui->imageLabel->height();
  w=labelWidth;
  h=labelHeight;
//  if (im.width()<w) w=im.width();
//  if (im.height()<h) h=im.height();
  if(activeMovie) return;
  if (fi.suffix().toLower()=="gif")
    {
      //we will try a animated gif
      qm.setFileName(fileName);
      if(qm.isValid())
        {
          if(qm.frameCount()>1)
            {
              ui->imageLabel->setScaledContents(true);
              activeMovie=true;
              ui->imageLabel->setMovie(&qm);
              qm.start();
            }
          else
            {
              ui->imageLabel->setPixmap(QPixmap::fromImage(im.scaled(w,h,Qt::KeepAspectRatio,Qt::SmoothTransformation)));
            }
        }
    }
  else
    {
      activeMovie=false;
      if(!im.isNull())
        {
          ui->imageLabel->setPixmap(QPixmap::fromImage(im.scaled(w,h,Qt::KeepAspectRatio,Qt::SmoothTransformation)));
        }
    }
}
